!	OpenVMS makefile for
!		MicroEMACS 4.0
!		(C)Copyright by Daniel Lawrence
!		all rights reserved
!               By Martin Vorlaender
!
! To use:
!	MMS|MMK [/MACRO=(macro-list)]
! where currently the only value defined for macro-list is
!	DEBUG=1		for the debug version
!

CC = CC/DECC	! don't use VAX C any more

# MMK doesn't support MMS$ARCH_NAME, and MMS doesn't support __ALPHA__
.ifdef __MMK__
.ifdef __ALPHA__
MMS$ARCH_NAME = Alpha
.else
MMS$ARCH_NAME = VAX
.endif
.endif

!
! Directories to use (relative to this one)
!
HDIR = [-.H]			! header files
SDIR = [-.SRC]			! source files
LDIR = [.LIS_$(MMS$ARCH_NAME)]	! listing/map files
!
!ODIR				! object/binary files
.ifdef DEBUG
ODIR = [.BINDBG_$(MMS$ARCH_NAME)]
.else
ODIR = [.BIN_$(MMS$ARCH_NAME)]
.endif


!
! Compile and link options
!
CCOMMON = /include=([],$(HDIR)) /object=$(MMS$TARGET) /prefix_library_entries=all_entries
LCOMMON = 
.ifdef DEBUG
CFLAGS    = $(CCOMMON) /debug /nooptimize /list=$(LDIR) /show=(expansion,noheader,include)
LINKFLAGS = $(LCOMMON) /debug /map=$(LDIR) /cross_reference
.else
CFLAGS    = $(CCOMMON)
LINKFLAGS = $(LCOMMON)
.endif

!
! The header file epath.h is used only by
! bind.c at this writing, so it appears
! on bind.c's dependancy list only.
!
HFILES = -
	$(HDIR)ebind.h,-
	$(HDIR)edef.h,-
	$(HDIR)efunc.h,-
	$(HDIR)evar.h,-
	$(HDIR)estruct.h

OFILES = -
	$(ODIR)abbrev.obj,-
	$(ODIR)ansi.obj,-
	$(ODIR)basic.obj,-
	$(ODIR)bind.obj,-
	$(ODIR)buffer.obj,-
	$(ODIR)char.obj,-
	$(ODIR)crypt.obj,-
	$(ODIR)display.obj,-
	$(ODIR)eval.obj,-
	$(ODIR)exec.obj,-
	$(ODIR)file.obj,-
	$(ODIR)fileio.obj,-
	$(ODIR)input.obj,-
	$(ODIR)isearch.obj,-
	$(ODIR)keyboard.obj,-
	$(ODIR)line.obj,-
	$(ODIR)lock.obj,-
	$(ODIR)main.obj,-
	$(ODIR)mouse.obj,-
	$(ODIR)random.obj,-
	$(ODIR)region.obj,-
	$(ODIR)replace.obj,-
	$(ODIR)screen.obj,-
	$(ODIR)search.obj,-
	$(ODIR)smg.obj,-
	$(ODIR)tags.obj,-
	$(ODIR)undo.obj,-
	$(ODIR)vms.obj,-
	$(ODIR)window.obj,-
	$(ODIR)word.obj


.first :
	@ IF F$SEARCH("BIN_$(MMS$ARCH_NAME).DIR") .EQS. "" THEN -
		CREATE/DIRECTORY [.BIN_$(MMS$ARCH_NAME)]
	@ IF F$SEARCH("BINDBG_$(MMS$ARCH_NAME).DIR") .EQS. "" THEN -
		CREATE/DIRECTORY [.BINDBG_$(MMS$ARCH_NAME)]
	@ IF F$SEARCH("LIS_$(MMS$ARCH_NAME).DIR") .EQS. "" THEN -
		CREATE/DIRECTORY [.LIS_$(MMS$ARCH_NAME)]


images : $(ODIR)meshr.exe, $(ODIR)me.exe
	@ CONTINUE

$(ODIR)me.exe : $(ODIR)me.obj, []descrip.mms
	$(LINK) $(LINKFLAGS) /executable=$(MMS$TARGET) $(ODIR)me.obj

$(ODIR)meshr.exe : $(ODIR)melib.olb, []me_$(MMS$ARCH_NAME).opt, []descrip.mms
	$(LINK) $(LINKFLAGS) /shareable=$(MMS$TARGET) -
		$(ODIR)melib.olb/library/include=main, -
		$(ODIR)melib.olb/library, -
		[]me_$(MMS$ARCH_NAME).opt/option

$(ODIR)melib.olb : $(ODIR)melib.olb( $(OFILES) )
	! $(LIBR)/COMPRESS $(MMS$TARGET) $(MMS$TARGET)
	@ CONTINUE


$(ODIR)abbrev.obj : $(SDIR)abbrev.c, $(HFILES)
$(ODIR)ansi.obj : $(SDIR)ansi.c, $(HFILES)
$(ODIR)basic.obj : $(SDIR)basic.c, $(HFILES)
$(ODIR)bind.obj : $(SDIR)bind.c, $(HFILES), $(HDIR)epath.h
$(ODIR)buffer.obj : $(SDIR)buffer.c, $(HFILES)
$(ODIR)char.obj : $(SDIR)char.c, $(HFILES)
$(ODIR)crypt.obj : $(SDIR)crypt.c, $(HFILES)
$(ODIR)display.obj : $(SDIR)display.c, $(HFILES)
$(ODIR)eval.obj : $(SDIR)eval.c, $(HFILES)
$(ODIR)exec.obj : $(SDIR)exec.c, $(HFILES)
$(ODIR)file.obj : $(SDIR)file.c, $(HFILES)
$(ODIR)fileio.obj : $(SDIR)fileio.c, $(HFILES)
$(ODIR)input.obj : $(SDIR)input.c, $(HFILES)
$(ODIR)isearch.obj : $(SDIR)isearch.c, $(HFILES)
$(ODIR)keyboard.obj : $(SDIR)keyboard.c, $(HFILES)
$(ODIR)line.obj : $(SDIR)line.c, $(HFILES)
$(ODIR)lock.obj : $(SDIR)lock.c, $(HFILES)
$(ODIR)main.obj : $(SDIR)main.c, $(HFILES)
$(ODIR)mouse.obj : $(SDIR)mouse.c, $(HFILES)
$(ODIR)random.obj : $(SDIR)random.c, $(HFILES)
$(ODIR)region.obj : $(SDIR)region.c, $(HFILES)
$(ODIR)replace.obj : $(SDIR)replace.c, $(HFILES)
$(ODIR)screen.obj : $(SDIR)screen.c, $(HFILES)
$(ODIR)search.obj : $(SDIR)search.c, $(HFILES)
$(ODIR)smg.obj : $(SDIR)smg.c, $(HFILES)
$(ODIR)tags.obj : $(SDIR)tags.c, $(HFILES)
$(ODIR)undo.obj : $(SDIR)undo.c, $(HFILES)
$(ODIR)vms.obj : $(SDIR)vms.c, $(HFILES)
$(ODIR)window.obj : $(SDIR)window.c, $(HFILES)
$(ODIR)word.obj : $(SDIR)word.c, $(HFILES)

$(ODIR)me.obj : []me.c

clean :
	- DELETE/LOG $(ODIR)*.obj;*,$(ODIR)melib.olb;*
	- DELETE/LOG $(LDIR)*.lis;*,$(LDIR)*.map;*

realclean : clean
	- DELETE_/LOG $(ODIR)*.exe;*

install : images
	IF "$(INSTALLDIR)" .EQS. "" THEN EXIT 44
	CREATE/DIRECTORY /PROTECTION=W:RE $(INSTALLDIR)
	COPY /PROTECTION=W:RE $(ODIR)MESHR.EXE,ME.EXE $(INSTALLDIR)
	COPY /PROTECTION=W:RE []EMACS.RC,FIND-VMSERR.CMD $(INSTALLDIR)
	COPY /PROTECTION=W:RE [-.CMD]*.*/EXCLUDE=EMACS.RC $(INSTALLDIR)
