;	FIND-VMSERR.CMD:	...
;
;	This command file defines a procedure to interpret VMS compiler
;	error messages, load the file and jump to the location of the error.
;
;	To use this:
;
;	1) Change to the window that contains the error messages
;	2) Pressing the bound key finds the next error message, loads
;	   the file, and jumps to the location of the error.

store-procedure find-vmserr
	delete-other-windows
	select-buffer "command.log"
	!force 4 next-line
	set %oldmode $cmode
	add-mode magic
	; Forward to the next line starting with a "%"
	!force search-forward "^%"
	; If not found, go to end of file and exit
	!if &seq $status FALSE
		end-of-file
		write-message "No more error messages"
		set $cmode %oldmode
		!return
	!endif
	; note the position of the previous "^"
	search-reverse "\^"
	set %caretpos $curcol
	1 clear-and-redraw
	; forward to line starting with "at line number "
	; get line number and file name from
	; "at line number <.> in file <...>"
	search-forward "^at line number \([0-9]+\) in file \(.+\)$"
	set %lineno &group 1
	set %file &group 2
	set $cmode %oldmode
	; load file
	1 split-current-window
	8 resize-window
	next-window
	find-file %file
	; jump to line, set column to position of "^"
	goto-line %lineno
	set $curcol %caretpos

	update-screen
!endm
