/*
     This file is part of GNUnet.
     (C) 2001, 2002 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * This module is responsible for breaking GNUnet. Er, for
 * handling collisions.
 * @file common/lookup_collision.c
 * @author Krista Bennett
 **/

#include "config.h"
#include "lookup_collision.h"

/* handle of the database-file, never closed yet */
static int LOOKUP_COLLISION_handle_;

/* semaphore for synced r/w access to the file */
static Mutex LOOKUP_COLLISION_fileSem_;

void initLookup_collision() {
  FileName fileName = getCollisionFile();
  LOOKUP_COLLISION_handle_ = open(fileName, O_CREAT|O_RDWR,S_IRUSR|S_IWUSR);
  if (LOOKUP_COLLISION_handle_ < 0) 
    errexit("Unable to open collision file %s. Exiting.\n", fileName);
  create_mutex(&LOOKUP_COLLISION_fileSem_);
}

/**
 * @return YES if found, NO if not.
 **/
int findCollisionEntry(HashCode160 * hc,
		       ContentIndex * entry) {
   int size;
   HashCode160 hash_again;


   MUTEX_LOCK(&LOOKUP_COLLISION_fileSem_);
   lseek(LOOKUP_COLLISION_handle_, 
	 0,
	 SEEK_SET);
   size = read(LOOKUP_COLLISION_handle_, 
	       entry, 
	       sizeof(ContentIndex)); 
   while (size == sizeof(ContentIndex)) {
     LOOPPRINT("findCollisionEntry");
     hash(&entry->doubleHash,
	  sizeof(HashCode160),
	  &hash_again);       
     if (equalsHashCode160(&hash_again, hc)) {
       MUTEX_UNLOCK(&LOOKUP_COLLISION_fileSem_);
       return YES;
     }     
     size = read(LOOKUP_COLLISION_handle_, 
		 entry, 
		 sizeof(ContentIndex));
    } 
   MUTEX_UNLOCK(&LOOKUP_COLLISION_fileSem_);
   return NO;
}

void addCollisionEntry(ContentIndex * entry) {
   ContentIndex existing_entry;
   int position;
   int size;
   
   position = 0;
   MUTEX_LOCK(&LOOKUP_COLLISION_fileSem_);
   lseek(LOOKUP_COLLISION_handle_, 
	 0, 
	 SEEK_SET); 
   size = read(LOOKUP_COLLISION_handle_, 
	       &existing_entry, 
	       sizeof(ContentIndex));
   while (size == sizeof(ContentIndex)) {
     LOOPPRINT("addCollisionEntry");
     if (equalsHashCode160(&existing_entry.doubleHash,
			   &entry->doubleHash)) 
       break;      
     if (size == sizeof(ContentIndex)) 
       position += size;
     size = read(LOOKUP_COLLISION_handle_, 
		 &existing_entry, 
		 sizeof(ContentIndex));
   }
   /* if we broke out of loop, this overwrites. Otherwise, we append to */
   /* end of file */
   lseek(LOOKUP_COLLISION_handle_, position, SEEK_SET); 
   write(LOOKUP_COLLISION_handle_, entry, sizeof(ContentIndex));
   MUTEX_UNLOCK(&LOOKUP_COLLISION_fileSem_);
}
