/*
     This file is part of GNUnet.
     (C) 2001, 2002 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * GNUnet statistics module
 * @author Christian Grothoff
 * @file common/statistics.c
 **/

#include "statistics.h"

Statistics GNUNET_STATISTICS;

void initStatistics() {
  bzero(&GNUNET_STATISTICS,
	sizeof(Statistics));
  time(&GNUNET_STATISTICS.start_time);
}

void doneStatistics() {
}

static void doNothing(HashCode160 * arg) {
}

void getStatistics(Statistics * stats) {
  int i;
  
  stats->header.tcpType = htons(TCP_REPLY_STATISTICS);
  stats->header.size = htons(sizeof(Statistics));
  for (i=0;i<GNET_PROTO_MAX;i++)
    stats->udp_in_counts[i] 
      = htonl(GNUNET_STATISTICS.udp_in_counts[i]);
  for (i=0;i<GNET_PROTO_MAX;i++)
    stats->udp_out_counts[i] 
      = htonl(GNUNET_STATISTICS.udp_out_counts[i]);
  stats->octets_total_udp_in 
    = htonl(GNUNET_STATISTICS.octets_total_udp_in);
  stats->octets_total_udp_out 
    = htonl(GNUNET_STATISTICS.octets_total_udp_out);
  for (i=0;i<TCP_MAX;i++)
    stats->tcp_in_counts[i] = htonl(GNUNET_STATISTICS.tcp_in_counts[i]);
  for (i=0;i<TCP_MAX;i++)
    stats->tcp_out_counts[i] = htonl(GNUNET_STATISTICS.tcp_out_counts[i]);
  stats->shared_files
    = htonl(GNUNET_STATISTICS.shared_files);
  stats->shared_size
    = htonl(GNUNET_STATISTICS.shared_size);
  stats->start_time
    = htonl(GNUNET_STATISTICS.start_time);
  stats->shared_files
    = htonl(getSharedFileCount());
  stats->shared_size
    = htonl(forEachEntryInDatabase(&doNothing));
}

void printStatistics(Statistics * stats) {
  time_t now;

  printf("Node-to-Node (udp):\n");
  printf("#HELO      received:  %8u  send:  %8u\n",
	 ntohl(stats->udp_in_counts[GNET_PROTO_HELO]),
	 ntohl(stats->udp_out_counts[GNET_PROTO_HELO]));
  printf("#SKEY      received:  %8u  send:  %8u\n",
	 ntohl(stats->udp_in_counts[GNET_PROTO_SKEY]),
	 ntohl(stats->udp_out_counts[GNET_PROTO_SKEY]));
  printf("#PING      received:  %8u  send:  %8u\n",
	 ntohl(stats->udp_in_counts[GNET_PROTO_PING]),
	 ntohl(stats->udp_out_counts[GNET_PROTO_PING]));
  printf("#PONG      received:  %8u  send:  %8u\n",
	 ntohl(stats->udp_in_counts[GNET_PROTO_PONG]),
	 ntohl(stats->udp_out_counts[GNET_PROTO_PONG]));
  printf("#3QUERY    received:  %8u  send:  %8u\n",
	 ntohl(stats->udp_in_counts[GNET_PROTO_3QUERY]),
	 ntohl(stats->udp_out_counts[GNET_PROTO_3QUERY]));
  printf("#CONTENT   received:  %8u  send:  %8u\n",
	 ntohl(stats->udp_in_counts[GNET_PROTO_CONTENT]),
	 ntohl(stats->udp_out_counts[GNET_PROTO_CONTENT]));
  printf("#TIMESTAMP received:  %8u  send:  %8u\n",
	 ntohl(stats->udp_in_counts[GNET_PROTO_TIMESTAMP]),
	 ntohl(stats->udp_out_counts[GNET_PROTO_TIMESTAMP]));
  printf("#SEQUENCE  received:  %8u  send:  %8u\n",
	 ntohl(stats->udp_in_counts[GNET_PROTO_SEQUENCE]),
	 ntohl(stats->udp_out_counts[GNET_PROTO_SEQUENCE]));
  printf("#NOISE     received:  %8u  send:  %8u\n",
	 ntohl(stats->udp_in_counts[GNET_PROTO_NOISE]),
	 ntohl(stats->udp_out_counts[GNET_PROTO_NOISE]));
  printf("#HANGUP    received:  %8u  send:  %8u\n",
	 ntohl(stats->udp_in_counts[GNET_PROTO_HANGUP]),
	 ntohl(stats->udp_out_counts[GNET_PROTO_HANGUP]));
  printf("#octets    received:  %8uk send:  %8uk\n",
	 ntohl(stats->octets_total_udp_in)/1024,
	 ntohl(stats->octets_total_udp_out)/1024);
  
  printf("\nServer-Client (tcp):\n");
  printf("#QUERY     received:  %8u  send:  %8u\n",
	 ntohl(stats->tcp_in_counts[TCP_REQUEST_QUERY]),
	 ntohl(stats->tcp_out_counts[TCP_REQUEST_QUERY]));
  printf("#CONTENT   received:  %8u  send:  %8u\n",
	 ntohl(stats->tcp_in_counts[TCP_REPLY_CONTENT]),
	 ntohl(stats->tcp_out_counts[TCP_REPLY_CONTENT]));
  printf("#INSERT    received:  %8u  send:  %8u\n",
	 ntohl(stats->tcp_in_counts[TCP_REQUEST_INSERT]),
	 ntohl(stats->tcp_out_counts[TCP_REQUEST_INSERT]));
  printf("#INDEX     received:  %8u  send:  %8u\n",
	 ntohl(stats->tcp_in_counts[TCP_REQUEST_INDEX]),
	 ntohl(stats->tcp_out_counts[TCP_REQUEST_INDEX]));
  printf("#LISTFILE  received:  %8u  send:  %8u\n",
	 ntohl(stats->tcp_in_counts[TCP_REQUEST_LIST_FILE]),
	 ntohl(stats->tcp_out_counts[TCP_REQUEST_LIST_FILE]));
  printf("#FILEINDEX received:  %8u  send:  %8u\n",
	 ntohl(stats->tcp_in_counts[TCP_REPLY_FILE_INDEX]),
	 ntohl(stats->tcp_out_counts[TCP_REPLY_FILE_INDEX]));
  printf("#STATREQ.  received:  %8u  send:  %8u\n",
	 ntohl(stats->tcp_in_counts[TCP_REQUEST_STATISTICS]),
	 ntohl(stats->tcp_out_counts[TCP_REQUEST_STATISTICS]));
  printf("#STATREPLY received:  %8u  send:  %8u\n",
	 ntohl(stats->tcp_in_counts[TCP_REPLY_STATISTICS]),
	 ntohl(stats->tcp_out_counts[TCP_REPLY_STATISTICS]));

  printf("\nServer Statistics:\n");
  printf("Shared files       :  %8u\n",
	 ntohl(stats->shared_files));
  printf("Size of shared data:  %8uk\n",
	 ntohl(stats->shared_size));
  time(&now);
  printf("Uptime             :  %8us\n",
	 (unsigned int)(now-ntohl(stats->start_time)));
}
