/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/**
 * This is the window displaying download results for
 * the gtk+ client.
 * @file src/gtkui/download.c
 * @author Christian Grothoff
 **/

#include "config.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/types.h>
#include <pthread.h>

#include "util/storage.h"
#include "textui/downloadutil.h"
#include "gtkui/download.h"


/* callback: window close: close the window */
static gint delete_event(GtkWidget * widget,
			 GdkEvent * event,
			 gpointer data) {
  return FALSE;
}

/* close window, kill download thread */
static void destroy(GtkWidget * widget,
		    gpointer data) {
  DownloadModel * dlm;

  dlm = data;
  pthread_cancel(dlm->downloadThread);  
  xfree(dlm,"download.c-destroy: dlm");
}

static void modelCallback(size_t downloaded,
			  size_t total,
			  void * data) {
  DownloadModel * model;
  gfloat percent;

  model = (DownloadModel*) data;
  percent = 1.0*downloaded/total;

  pthread_setcancelstate(PTHREAD_CANCEL_DISABLE, NULL);
  gdk_threads_enter();
  gtk_progress_bar_update(GTK_PROGRESS_BAR(model->progressBar),
			  percent); 
  gdk_threads_leave();
  pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);
}

/**
 * Main method of the download thread.
 **/
static void downloadFile_(DownloadModel * dlm) {
  int res;

  pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);
  pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);
  res = downloadFile(&dlm->root.hashCode,
		     dlm->root.crc,
		     dlm->root.file_length,
		     dlm->fileName,
		     &modelCallback,
		     dlm);
  /* res == 0: ok, -1: failed */
}

void startDownload(DownloadModel * dlm) {
  GtkWidget * window;
  GtkWidget * box; 

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), dlm->fileName);
  box = gtk_hbox_new(FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), box);
  gtk_signal_connect (GTK_OBJECT (window), 
		      "delete_event",
		      GTK_SIGNAL_FUNC (delete_event), 
		      dlm);
  gtk_signal_connect (GTK_OBJECT (window), 
		      "destroy",
		      GTK_SIGNAL_FUNC (destroy), 
		      dlm);
  gtk_container_set_border_width (GTK_CONTAINER (window), 10);
  /* search entry */
  dlm->progressBar = gtk_progress_bar_new();
  gtk_progress_set_show_text(GTK_PROGRESS(dlm->progressBar),
			     1);
  gtk_progress_set_format_string(GTK_PROGRESS(dlm->progressBar),
				 (gchar*)"%p");
  gtk_box_pack_start(GTK_BOX(box), 
		     dlm->progressBar, TRUE, TRUE, 0);
  gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(dlm->progressBar),
				   GTK_PROGRESS_LEFT_TO_RIGHT);
  gtk_widget_show(dlm->progressBar);
  /* main window */
  gtk_widget_show(box);

  pthread_create(&dlm->downloadThread,
		 NULL,
		 (void * (*)(void *)) downloadFile_,
		 dlm); 
  gtk_widget_show (window);
}

/* end of download.c */
