/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/**
 * This code opens the save as window.
 * @file src/gtkui/saveas.c
 * @author Christian Grothoff
 **/

#include "config.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/types.h>
#include <pthread.h>

#include "util/storage.h"
#include "textui/downloadutil.h"
#include "gtkui/download.h"
#include "gtkui/saveas.h"

/* close window, kill download thread */
static void destroy(GtkWidget * widget,
		    gpointer data) {
  xfree(data,"saveas.c: destroy: DownloadModel: save as closed");
}


/* Get the selected filename and print it to the console */
void file_ok_sel(GtkWidget        *w,
		 DownloadModel * dlm) {
  gchar * filename;

  filename
    = gtk_file_selection_get_filename(GTK_FILE_SELECTION (dlm->saveAsWindow));
  dlm->fileName = xmalloc(strlen(filename)+1,
			  "file_ok_sel: filename");
  strcpy(dlm->fileName, filename);
  startDownload(dlm);
  gtk_widget_hide(dlm->saveAsWindow);
}


/**
 * Open the window that prompts the user for the 
 * filename.
 * This method must open the window,
 * copy the arguments and return. After the method
 * returns, the arguments passed to it will be
 * freed, so pointer should not be retained.
 * The method executes during a signal handler,
 * so a GTK lock is not required to to GUI 
 * operations.
 **/
void openSaveAs(char * desc,
		char * lenStr,
		char * crcStr,
		char * hashStr,
		char * defaultFilename) {
  DownloadModel * dlm;
  GtkWidget * window;
  RootNode * root;
  
  dlm = xmalloc(sizeof(DownloadModel),
		 "startDownload: downloadModel");  
  root = &dlm->root;
  sscanf(lenStr,"%d",&root->file_length);
  sscanf(crcStr,"%ld",&root->crc);
  hex2hash((HexName*)hashStr,
	   &root->hashCode);
  if (strlen(root->description) >= MAX_DESC_LEN) {
    root->description[MAX_DESC_LEN-1] = 0;
    print("This should never happen, description too long (%s)!\n",
	  root->description);
    xfree(root,"root free - aborting...");
    return;
  }
  memcpy(&root->description,
	 desc,
	 strlen(desc)+1);  

  window = gtk_file_selection_new("save as");  
  if (defaultFilename != NULL)
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(window),
				    defaultFilename);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      (GtkSignalFunc) destroy, 
		      dlm);
  /* Connect the ok_button to file_ok_sel function */
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (window)->ok_button),
		      "clicked", (GtkSignalFunc) file_ok_sel, 
		      dlm );
  
  /* Connect the cancel_button to destroy the widget */
  gtk_widget_hide(GTK_FILE_SELECTION (window)->cancel_button);
  dlm->saveAsWindow = window;
  gtk_widget_show(window);
}

/* end of saveas.c */
