/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * Configuration management.
 * @author Christian Grothoff
 * @file include/configuration.h
 **/

#ifndef CONFIGURATION_H
#define CONFIGURATION_H

#ifdef  __cplusplus
extern "C" {
#endif

#include "config.h"
#include "gnettypes.h"
#include "util/ipcheck.h"
#include "util/statuscalls.h"

/**
 * Maximum number of concurrent gproxies accessing this node.
 * Length of the sockDescriptors array.
 **/
#define CONCOUNT 4

/**
 * This method must be called first! It reads
 * the config file and makes everything else
 * possible.
 **/
void readConfig(FileName filename);

/**
 * This method may be called at last to clean up.
 * Afterwards everything but readConfig will result
 * in errors...
 **/
void freeConfig();

/* *************** network configuration ********* */

unsigned short getGNUnetPort();

unsigned int getMaxNetLoad();

unsigned int getMaxNetBPSTotal();

IPAddress getIP();

Interfaces getNetInterfaces();
 
CIDRNetwork * getNetBlacklist();
  
CIDRNetwork * getTCPWhitelist();

char * getHostlistURL();

/* ********************* Filesharing options ********************* */

/* @return YES if on, NO if off */
int activeMigration();

/* 0: never */
unsigned int getSearchTimeout();

char * getExtractorConfig();

/* ********************* File options ********************* */

unsigned int getDiskQuota();

FileName getHostKeyFilePriv();

FileName getDatabaseFile();

FileName getCollisionFile();

FileName getSharedFileList();

FileName getAgeFile();

FileName getCreditDirectory();

FileName getContentDirectory();

FileName getHostsDirectory();

/* ************* server options ***************** */

/**
 * How many hours is a HELO message valid?
 **/
unsigned int getHeloExpiration();

/**
 * Are we a router connecting to a private
 * network and should thus not forward HELOs?
 * @return NO if no HELOs should be forwarded, YES if helos should be exchanged
 **/
int isHELOEnabled();

unsigned int getMaxLoad();

unsigned int getMaxNodes();

#ifdef  __cplusplus
}
#endif

#endif
/* end of configuration.h */
