/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file gtkui/download.h
 * @author Christian Grothoff
 **/

#ifndef GTKUI_DOWNLOAD_H
#define GTKUI_DOWNLOAD_H

#include "config.h"
#include <gtk/gtk.h>
#include <glib.h>

typedef struct {
  RootNode root;
  char * fileName;
  pthread_t downloadThread;
  GtkWidget * progressBar;
  GtkWidget * saveAsWindow;
} DownloadModel;

/**
 * Start the download given in the arguments.
 * This method must open the download window,
 * initiate the download (start thread in the
 * background) and return.
 * The method executes during a signal handler,
 * so a GTK lock is not required to to GUI 
 * operations.
 **/
void startDownload(DownloadModel * dlm);

#endif
