/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * This module is responsible for breaking GNet. Er, for
 * handling collisions.
 * @file gnet/include/lookup_collision.h
 * @author Krista Bennett
 **/

#ifndef LOOKUP_COLLISION_H
#define LOOKUP_COLLISION_H

#include "config.h"
#include "gnettypes.h"
#include "configuration.h"

void initLookup_collision();

int findCollisionEntry(HashCode160 * hc,
		       ContentIndex * entry);

void addCollisionEntry(ContentIndex* entry);

#endif
