/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/**
 * Main handler for incoming packets.
 * @author Christian Grothoff
 * @file gnet/include/handler.h
 **/

#ifndef HANDLER_H
#define HANDLER_H

#include "config.h"
#include "gnettypes.h"
#include "util/checksum.h"
#include "server/identity.h"
#include "server/keyservice.h"
#include "server/policy.h"
#include "server/routing.h"
#include "server/tcpserver.h"
#include "server/connection.h"

/**
 * The actual main method of gnet: message dispatch/handling.
 * @param msg the message that was received. caller frees it on return
 * @param id number of the current thread
 **/
void handle(int id, MessagePack * msg);

#endif
/* end of handler.h */
