/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * Cron-jobs exchanging routing information (HELOs messages)
 * @author Christian Grothoff
 * @file include/server/heloexchange.h
 **/

#ifndef HELOEXCHANGE_H
#define HELOEXCHANGE_H

#include "config.h"
#include <unistd.h>

#include "gnettypes.h"
#include "server/handler.h"
#include "server/connection.h"
#include "server/identity.h"
#include "server/keyservice.h"
#include "util/cron.h"

/**
 * initialize a few cron jobs. Must be called after
 * initcron (!).
 **/
void initCronJobs();

/**
 * We have received a HELO. Verify (signature, integrity,
 * ping-pong) and store identity if ok.
 **/
void receivedHELO(HELO_Body * body);
 
/**
 * Download hostlist from the web. This method is invoked
 * when gnunetd starts and if we suddenly know no more hosts.
 **/
void downloadHostlist(void * unused);

/* end of heloexchange.h */
#endif
