/*
     This file is part of GNUnet.
     (C) 2001, 2002 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

#ifndef PINGPONG_H
#define PINGPONG_H

/**
 * Pingpong hander. Pings a host and triggers an action if a
 * reply is received.
 * @author Christian Grothoff
 * @file server/pingpong.c
 **/

#include "util/cron.h"
#include "server/identity.h"
#include "util/semaphore.h"

void initPingPong();

void donePingPong();

/**
 * Ping a host an call a method if a reply comes back.
 * @param receiver the IP address to use for the ping
 * @param receiverIdentity the identity to fill into the ping
 * @param method the method to call if a PONG comes back
 * @param an argument to pass to the method.
 **/
void pingAction(HostAddress * receiver,
		HostIdentity * receiverIdentity,
		void (*method)(void *),
		void * data);
		
void pongReceived(HostIdentity * responderIdentity,
		  int challenge);

#endif
