/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/**
 * Routing interface. This is the interface that does the routing.
 * @author Christian Grothoff
 * @file include/routing.h
 **/

#ifndef ROUTING_H
#define ROUTING_H

#include "config.h"
#include "gnettypes.h"
#include "server/connection.h"
#include "server/tcpserver.h"
#include "util/semaphore.h"
#include "util/cron.h"

extern  HostIdentity ROUTING_localhost_;

/**
 * Initialize routing module.
 **/
void initRouting();

/**
 * Print the current routing table.
 **/
void printRoutingTable();

/**
 * Execute the triple-hash query. This method does NOT check the QUERY
 * Policy, it is used either after the policy was checked or if the
 * request is trusted (especially needed if comes from our client).
 *
 * @param qp the polciy (priorty, etc) for the query
 * @param msg the query message (with host identity for the reply)
 * @param sock the TCP socket to send the answer to if it is
 *        a query from the local host, otherwise NULL.
 **/
void exec3Query(QUERY_POLICY qp, QUERY_Message * msg,
		GNUNET_TCP_SOCKET * sock);

/**
 * Content has arrived. We must decide if we want to a) forward it to
 * our clients b) indirect it to other nodes. The routing module
 * should know what to do.
 *
 * @return how good this content was (priority of the request)
 **/
int useContent(HostIdentity * hostId,
	       CONTENT_Block * content,
	       HashCode160 * hash);

/**
 * TCP connection is shut down, cancel all
 * replies to that client.
 **/
void cancelTCP(GNUNET_TCP_SOCKET * sock);
 

#endif
/* end of routing.h */
