/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/**
 * sessionkey management
 * @author Christian Grothoff
 * @file include/sessionkey.h
 **/

#ifndef SESSIONKEY_H
#define SESSIONKEY_H

#include "config.h"
#include "gnettypes.h"
#include "symcipher.h"
#include "util/returnvalues.h"
#include "server/identity.h"

/**
 * Accept a session-key that has been sent by another host.
 * The other host must be known (public key)
 * @param hostId the identity of the sender host
 * @param sessionkey the session key that was "negotiated"
 * @param sig the signature to verify the sessionkey is ok
 **/
void acceptSessionKey(HostIdentity * hostId,
		      SKEY_Message * sessionkeySigned);

/**
 * Perform a session key exchange for entry be.
 * First sends a HELO and then the new SKEY
 * (in one unencrypted packet). When called, the 
 * semaphore of at the given index must already be down
 **/
void exchangeKey(BufferEntry * be);

/**
 * Shutdown the connection.
 * Send a HANGUP message to the other side and
 * mark the sessionkey as dead.
 **/
void shutdownConnection(BufferEntry * be);


#endif
/* end of sessionkey.h */
