/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/**
 * Helper methods for the startup of gnet. Do 
 * some checks, commandline parsing and bind
 * to UDP port.
 *
 * @file gnet/include/startup.h
 * @author Christian Grothoff
 **/

#ifndef STARTUP_H
#define STARTUP_H

#include "config.h"
#include "gnettypes.h"
#include "configuration.h"
#include "getopt.h"

/**
 * Print a list of the options we offer.
 **/
void printhelp();

/**
 * Check if the compiler did a decent job.
 **/
void checkCompiler();

/**
 * Perform option parsing from the command line. 
 **/
int parseCommandLine(int argc, 
		     char * argv[],
		     char ** configFile);

/**
 * Allocate & bind a server socket using UDP
 * @param port the port in host byte order
 **/
int passivesock(unsigned short port);

#endif 
/* end of startup.h */
