/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/**
 * TCP server (gnunetd-client communication).
 * @author Christian Grothoff
 * @file include/server/tcpserver.h
 **/

#ifndef TCPSERVER_H
#define TCPSERVER_H

#include "config.h"
#include "gnettypes.h"
#include "configuration.h"
#include "server/handler.h"
#include "server/policy.h"
#include "server/keyservice.h"
#include "util/semaphore.h"

/**
 * Initialize the TCP port and listen for incoming client connections.
 **/
void startTCPListener();

/**
 * Shutdown the module. - not implemented.
 **/ 
void doneTCPListener();

#endif
/* end of tcpserver.h */
