/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/**
 * This file provides methods to manipulate host credit
 * rankings. It should be merged with outbuffer soon.
 * @author Tzvetan Horozov
 * @author Christian Grothoff
 **/ 

#ifndef TRUSTSERVICE_H
#define TRUSTSERVICE_H

#include "config.h"
#include "gnettypes.h"
#include "symcipher.h"
#include "configuration.h"
#include "server/sessionkey.h"
#include "server/identity.h"
#include "util/cron.h"
#include "util/semaphore.h"

/**
 * Initialize this module.
 **/
void initTrustService();

/**
 * Increase the host credit by a value - synchronized
 * @param hostId is the identity of the host
 * @param value is the int value by which the host credit is to be increased
 * @returns the new credit
 */
unsigned int changeHostCredit(HostIdentity * hostId, int value);

/**
 * Obtain the credit record of the host.
 **/
unsigned int getHostCredit(HostIdentity * hostId);

/**
 * Read host-information from a file. The semaphore
 * of the given be must already be down.
 **/
void initHostTrust(BufferEntry * be);

/**
 * Write host-infromation to a file - flush the buffer entry!
 * The semaphore must already be down when calling.
 **/
void flushHostCredit(BufferEntry * be,
		     void * unused);

#endif
/* end of trustservice.h */

