/*
     This file is part of GNUnet.
     (C) 2001, 2002 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * GNUnet statistics module
 * @author Christian Grothoff
 * @file include/statistics.h
 **/
#ifndef STATISTICS_H
#define STATISTICS_H

#include "gnettypes.h"

typedef struct {
  /** The TCP header (values: sizeof(Statistics), TCP_REPLY_STATISTICS) **/ 
  TYPED_TCP_HEADER header;
  unsigned int udp_in_counts[GNET_PROTO_MAX];
  unsigned int udp_out_counts[GNET_PROTO_MAX];
  unsigned int octets_total_udp_in;
  unsigned int octets_total_udp_out;
  unsigned int octets_total_tcp_in;
  unsigned int octets_total_tcp_out;
  unsigned int tcp_in_counts[TCP_MAX];
  unsigned int tcp_out_counts[TCP_MAX];
  /* number of files that are on-demand encoded and shared 
     (indexed) */
  unsigned int shared_files;
  /* size of the files stored in the local database (not the
     shared_files) in kilobytes */
  unsigned int shared_size;
  /* timestamp from when the server was started */
  time_t start_time;
} Statistics;

extern Statistics GNUNET_STATISTICS;

void initStatistics();

void doneStatistics();

void getStatistics(Statistics * stats);

void printStatistics(Statistics * stats);


#endif
