/*
     This file is part of GNUnet.
     (C) 2001, 2002 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * Helper functions for downloading.
 *
 * @author Christian Grothoff
 * @file include/textui/downloadutil.h
 **/

#ifndef TEXTUI_DOWNLOADUTIL_H
#define TEXTUI_DOWNLOADUTIL_H

#include "config.h"
#include "textui/requestmanager.h"

/**
 * Download a file.
 * @param hashC the hash of the file
 * @param crc32 the CRC of the file
 * @param filesize the size of the file
 * @param fileName the name of the file
 * @param model the download model used to
 *        update status information; points to NULL if
 *        no status updates shall be given, otherwise 
 *        to a method that takes two size_t arguments
 *        (retrieved so far, total) and the data 
 *        pointer.
 * @param data pointer that is passed to the model method.
 **/
int downloadFile(HashCode160 * hashC,
		 Ulong crc32,
		 size_t filesize,
		 char * fileName,
		 void (*model)(size_t, size_t, void*),
		 void * data);

#endif
/* end of downloadutil.h */
