/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/**
 * insertFile - breaks file meant for insertion into blocks, prepares
 *              for insertion into network
 * @author Krista Bennett
 * @file gnet/include/insertfile.h
 **/

#ifndef INSERT_FILE_H
#define INSERT_FILE_H

#include "config.h"
#include "util/storage.h"
#include "util/checksum.h"
#include "gnettypes.h"
#include "configuration.h"
#include "symcipher.h"

void initInsertfile();
void doneInsertfile();

/**
 * Inserts a file under the given name into the local gnet node.
 * @param filename the name of the (incoming/source) file
 * @param description the description of the file
 * @param keywords the keywords that shall be used to retrieve the file
 * @param num_keys the number of keywords we are to associate with the file
 * @param index: file-index if we are just indexing, -1 if we do 
 *                 full insertion.
 * @return OK or SYSERR
 **/
int insertFile(FileName filename,
	       char * description,
	       char * filenameRoot,
	       char * mimetype,
	       char ** keywords,
               int num_keys,
	       int index); 

/**
 * ask gnunetd to append a filename,
 * @return the index
 **/
int askAppendFilename(char * filename);

#endif
