/**
 * Layer to encapsulate the keyword extraction API and
 * make it accessible to gnunet-insert.
 * @file src/include/textui/keywords.h
 * @author Christian Grothoff
 **/

#ifndef KEYWORDS_H
#define KEYWORDS_H

#include "config.h"

#ifdef HAVE_EXTRACTOR_H
  #include <extractor.h>
#else
  typedef struct Extractor {
  } ExtractorList;
#endif

/**
 * Extract keywords, mime-type and description from a file
 * @param filename the name of the file
 * @param description the description (the user may have
 *        supplied a description already (*description != NULL),
 *        in that case, append, mind the maximum size!
 * @param mimetype the mimetype, again, the user may
 *        have supplied one
 * @param keywords the list of keywords, allocate space at
 *        another location if required, copy existing keywords
 *        over to that space!
 * @param num_keywords the number of keywords in the
 *        existing *keywords array that was passed in.
 *        Set *num_keywords to the new number of keywords!
 **/
void extractKeywords(char * filename,
		     char ** description,
		     char ** mimetype,
		     char *** keywords,
		     int * num_keywords);


#ifdef HAVE_LIBEXTRACTOR
  ExtractorList * getExtractors();
#endif


/**
 * Extract keywords, mime-type and description from a file
 * @param filename the name of the file
 * @param description the description (the user may have
 *        supplied a description already (*description != NULL),
 *        in that case, append, mind the maximum size!
 * @param mimetype the mimetype, again, the user may
 *        have supplied one
 * @param keywords the list of keywords, allocate space at
 *        another location if required, copy existing keywords
 *        over to that space! Do NEVER free *keywords!
 * @param num_keywords the number of keywords in the
 *        existing *keywords array that was passed in.
 *        Set *num_keywords to the new number of keywords!
 **/
void extractKeywordsMulti(char * filename,
			  char ** description,
			  char ** mimetype,
			  char *** keywords,
			  int * num_keywords,
			  ExtractorList * exList);

#endif
