/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/**
 * This module represents one of the nodes representing the
 * 1k entities in the tree when downloading a file.
 * @author Christian Grothoff
 **/

#ifndef NODE_H
#define NODE_H

#include "config.h"
#include "gnettypes.h"

/**
 * This method is used to notify the node that
 * some relevant data may have arrived.
 * @param hash filename of data that has arrived
 * @param data data corresponding to the hash code
 **/
int nodeReceive(Node * node,
		HashCode160 * hash, 
		CONTENT_Block * data);

/**
 * Return the length of the block without padding
 * @return CONTENT_BLOCK_SIZE except for
 *         the last block if the last block is padded.	 
 **/
int nodeGetBlockLength(Node * node);

/**
 * Check if the node is already on the drive. If not,
 * initiate the download. Otherwise notify the INode
 * that the download is complete.
 **/
void tryPresent(Node * node);
 

/**
 * Return the length of the block without padding that
 * matches actual content of the INode.
 * @return the length in bytes, including
 *         the hashcode and the indirection-hashes
 **/
int inodeGetBlockLength(INode * inode);

/**
 * This method is used to notify the node that
 * some relevant data may have arrived.
 * @param hash filename of data that has arrived
 * @param data data corresponding to the hash code
 **/
int inodeReceive(INode * inode,
		 HashCode160 * hash, 
		 CONTENT_Block * data);

/**
 * Abort this download.
 **/
void inodeAbort(INode * inode);

/**
 * This code is called both to notify 
 * this node that another of its children is complete
 * as well as to notify this node's parent that
 * this node is complete when all of its
 * children's downloads are complete.
 **/
void inodeNotifyReceivedData(INode * inode);


#endif
