/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/** 
 * The RequestManager keeps track and re-issues
 * requests for Content-Nodes.
 * @file include/requestmanager.h
 * @author Christian Grothoff
 **/ 

#ifndef REQUESTMANAGER_H
#define REQUESTMANAGER_H

#include "config.h"
#include "gnettypes.h"
#include "util/semaphore.h"
#include "util/cron.h"
#include "util/tcpio.h"

/**
 * Initialize the request manager module.
 **/
void initRequestManager();

void doneRequestManager();

/**
 * This method receives data corresponding to the indicated filename (hashcode)
 * Find the Listener that scheduled this request and
 * drop it from the list of pending requests.
 * @param hash hashcode representing filename
 * @param data data corresponding to this node
 **/ 
void requestManagerReceive(HashCode160 * hash, 
			   CONTENT_Block * data);

/**
 * Queue a request for execution.
 **/
void requestManagerRequest(Node * node,
			   Listener callback);

/**
 * Start download thread that will exit once the
 * download for the given root-node is complete.
 *
 * @param root the file to download
 **/
void requestManagerReceiveResults(RNode * root,
				  void * data);

/**
 * Abort a request
 * @param node what was the query
 **/
void requestManagerAbort(Node * node);

#endif
