/*
     This file is part of GNUnet.
     (C) 2001, 2002 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * Helper functions for searching.
 *
 * @author Christian Grothoff
 * @file textui/searchutil.c 
 **/

#ifndef TEXTUI_SEARCHUTIL_H
#define TEXTUI_SEARCHUTIL_H

#include "config.h"
#include "symcipher.h"
/**
 * Initialize this modul.
 * @return OK if successful, SYSERR on error
 **/ 
int initSearchUtil(char * hostname,
		   unsigned short port);


void doneSearchUtil();

/**
 * Start retrieving results from GNUnet.

 * @param keyCount the number of keywords
 * @param keywords the keywords (for decryption)
 * @param messages the queries (to match against)
 * @param handler the method to call on each result matching all keywords
 * @param handlerArgs the arguments to the result handler method
 **/
void receiveResults(int keyCount,
		    HashCode160 keywords[],
		    TCP_Query_Request messages[],
		    void * handler,
		    void * handlerArgs);

/**
 * Repeatedly send out the queries to GNUnet.
 * @param keyCount the number of queries/keys
 * @param timeout how long to do it (in seconds)
 * @param messages the initialized queries (will be modified as priorities/ttl increase)
 * @return 0
 **/
int sendQueries(int keyCount,
		int timeout,
		TCP_Query_Request messages[]);

/**
 * Build an initial set of query messages
 * from the list of keywords.
 * @param keyCount the number of keywords
 * @param keywords the keywords (or keys)
 * @param messages the resulting query messages
 **/
void buildMessages(int keyCount,
		   HashCode160 keywords[],
		   TCP_Query_Request * messages[]);

/**
 * Parse the keywords (join at spaces, separate at AND).
 * @param num_keywords the number of ascii-keywords
 * @param keywords the list of ascii-keywords
 * @param keys the hashs of the keywords to set (= the keys, not the queries!)
 * @return -1 on error, 0 if we should exit without error, number of keys if we actually are going to do something
 **/
int parseKeywords(int num_keywords,
		  char ** keywords,
		  HashCode160 * keys[]);

#endif
/* end of searchutil.h */
