/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/**
 * ContentDatabse - management of the 1k blocks...
 * @author Christian Grothoff
 * @file gnet/include/contentdatabase.h
 **/

#ifndef CONTENTDATABASE_H
#define CONTENTDATABASE_H

#include "config.h"
#include "storage.h"

/**
 * init the storage module.
 * @param dir the name of the directory/file
 *        containing the content database
 **/
void initContentDatabase(char * dir);

/**
 * Clean shutdown of the storage module (not used at the moment)
 **/
void doneContentDatabase();

/**
 * Free space in the database by removing one file
 * @param fn the name of the file (without directory)
 **/
void unlinkFromDB(HashCode160 * fn);
 
/**
 * Read the contents of a bucket to a buffer.
 * @param fn the hashcode representing the name of the file, not freed!
 * @param len the maximum number of bytes to read
 * @param result the buffer to write the result to
 * @return the number of bytes read on success, -1 on failure
 **/ 
int readContent(HashCode160 * fn,
		int  len,
		void * result);

/**
 * Write content to a file. Check for reduncancy and eventually
 * append.
 * @param fn the name of the file (without directory)
 * @param block the CONTENT_SIZE bytes long block (no header!)
 **/
void writeContent(HashCode160 * fn, 
		  CONTENT_Block * block);

/**
 * Call a method for each entry in the database and
 * call the callback method on it. 
 * @return the number of items stored in the content database
 **/
int forEachEntryInDatabase(void (*callback)(HashCode160*));
 
#endif

/* end of contentdatabase.h */
