/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/**
 * The cron service.
 * @author Christian Grothoff
 * @file gnet/include/cron.h
 **/

#ifndef CRON_H
#define CRON_H

#include "config.h"

#include <unistd.h>
#include <pthread.h>

#include "semaphore.h"
#include "xmalloc.h"

/**
 * Initialize controlThread.
 **/
void initCron();

/**
 * Start the cron jobs.
 **/
void startCron();

/**
 * Add a cron-job to the delta list.
 * @param method which method should we run
 * @param delta how many seconds until we run the method
 * @param deltaRepeat if this is a periodic, the time between
 *        the runs, otherwise 0.
 * @param data argument to pass to the method
 **/
void addCronJob(void (*method)(void*),
		int delta,
		int deltaRepeat,
		void * data);

/**
 * Remove a cron-job from the list. NOT IMPLEMENTED!
 * @param method which method is listed?
 * @param repeat which repeat factor was chosen? 
 * @param data what was the data given to the method
 **/
void delCronJob(void (*method)(void*),
		int repeat,
		void * data);

/* end of cron.h */
#endif
