/*
     This file is part of GNUnet
     (C) 2001, 2002 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/**
 * These functions deal with checking IP addresses against a blacklist
 * @file src/include/ipcheck.h
 * @author Christian Grothoff
 **/

#ifndef IPCHECK_H
#define IPCHECK_H

#include "config.h"

#ifdef SOMEBSD
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <net/if.h>
#else
  #include <sys/socket.h>
#endif
#include <netinet/in.h>
#include <string.h>
#include <stdio.h>


#include "xmalloc.h"


typedef struct {
  unsigned int addr;
} IPaddr;

/**
 * Struct describing a network in CIDR notation.
 **/
typedef struct {
  IPaddr network;
  IPaddr netmask;
} CIDRNetwork;

/**
 * Parse a network specification. The argument specifies
 * a list of networks. The format is
 * <tt>[network/netmask;]*</tt> (no whitespace, must be terminated
 * with a semicolon). The network must be given in dotted-decimal
 * notation. The netmask can be given in CIDR notation (/16) or
 * in dottet-decumal (255.255.0.0).
 * <p>
 * @param routeList a string specifying the forbidden networks
 * @return the converted list, NULL if the synatx is flawed
 **/
CIDRNetwork * parseRoutes(char * routeList);

/**
 * Check if the given IP address is in the list of 
 * IP addresses.
 * @param list a list of networks
 * @param ip the IP to check
 * @return NO if the IP is not in the list, YES if it it is
 **/
int checkIPListed(CIDRNetwork * list,
		  struct in_addr ip);


#endif

/* end of ipcheck.h */
