/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/*
 * File:  include/util/semaphore.h
 *
 */

#include "config.h"

#include <stdio.h>
#include <pthread.h>
#include <stdlib.h>

#include "xmalloc.h"

#ifndef SEMAPHORES
#define SEMAPHORES

#define DEBUG_LOCKING 0

typedef struct Semaphore {
    int         v;
    pthread_mutex_t mutex;
    pthread_cond_t cond;
} Semaphore;

typedef struct Mutex {
  pthread_mutex_t pthreadMutex;
} Mutex;

Semaphore * new_semaphore (int value);
int      semaphore_down (Semaphore * s);
int      semaphore_up (Semaphore * s);

void create_mutex(Mutex * mutex);
void create_recursive_mutex(Mutex * mutex);
void destroy_mutex(Mutex * mutex);
void mutex_lock(Mutex * mutex);
void mutex_unlock(Mutex * mutex);

#if DEBUG_LOCKING
#define MUTEX_LOCK(a) do { \
  print("Aquireing lock %x at line %d in file %s\n", \
	a,__LINE__, __FILE__); \
  mutex_lock(a); \
}\
while (0)
#define MUTEX_UNLOCK(a) do { \
  print("Releasing lock %x at line %d in file %s\n", \
	a,__LINE__, __FILE__); \
  mutex_unlock(a); \
}\
while (0)
#else
#define MUTEX_LOCK(a) mutex_lock(a)
#define MUTEX_UNLOCK(a) mutex_unlock(a)
#endif



#endif
