/*
     This file is part of GNUnet

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/
/** 
 * Status calls implementation.
 * @author Tzvetan Horozov
 * @author Christian Grothoff
 * @file util/statuscalls.h
 **/

#ifndef STATUSCALLS_H
#define STATUSCALLS_H

#include "config.h"

#include "storage.h"

typedef unsigned char * Interfaces;

/**
 * The following routine returns the percentage of
 * available used bandwidth. A number from 0-100 is returned.
 * Example: If 81 is returned this means that 81% of the network 
 * bandwidth of the host is consumed.
 */
int networkUsage();

/**
 * The following routine returns a number between 0-100 which 
 * indicates the percentage of disk space used
 */
int diskUsage();

/**
 * The following routine returns a number between 0-100 which indicates
 * the percentage CPU usage.
 */
int cpuUsage();

/**
 * The following method is called in order to initialize the status calls
 * routines. After that it is safe to call each of the status calls separately
 */
int initStatusCalls(Interfaces interfaces,
		    int maxNet);

#endif
