/**
 * Testcase for cron.
 *
 * @author Christian Grothoff
 * @file test/crontest.c
 **/

#include "config.h"
#include <stdio.h>
#include <string.h>

#include "util/cron.h"

int global;
int global2;
int global3;
pthread_t pthread;

/**
 * Process the cron-job at the beginning of the waiting
 * queue, that is, remove, invoke, and re-insert if
 * it is a periodical job. Make sure the sync is down
 * while the job is running (it may add other jobs!)
 **/
void runJob();

void cronJob() {
  global++;
}
void cronJob2() {
  global2++;
}
void cronJob3() {
  global3++;
}

int testCron() {
  int i;

  global = -1;
  global2 = -1;
  global3 = -1;
  addCronJob(cronJob, 1, 1);
  addCronJob(cronJob2, 4, 4);
  addCronJob(cronJob3, 16, 16);
  for (i=0;i<10;i++) {
    /*    fprintf(stderr,"."); */
    sleep(1);   
    if (((global-i) * (global-i)) > 9) {
      fprintf(stderr,"1: Expected %d got %d\n", i, global);
      return 1;
    }
    if (((global2-(i>>2)) * (global2-(i>>2))) > 9) {
      fprintf(stderr,"2: Expected %d got %d\n", i>>2, global2);
      return 1;
    }
    if (((global3-(i>>4)) * (global3-(i>>4))) > 9) {
      fprintf(stderr,"3: Expected %d got %d\n", i>>4, global3);
      return 1;
    }
  }
  return 0;
}


int main(int argc, char * argv[]) {
  int failureCount = 0;

  initCron();
  startCron();
  failureCount += testCron(); 
  
  if (failureCount == 0) 
    return 0;
  else {
    printf("\n\n%d TESTS FAILED!\n\n",failureCount);
    return -1;
  }
} // end of main
