/**
 * Hostkey - public key crypto. This is the testcase!
 * @author Christian Grothoff
 * @file test/hostkeytest.c
 **/

#include "config.h"
#include <stdio.h>
#include <string.h>
#include "util/hostkey.h"
#include "util/returnvalues.h"

#define TESTSTRING "Hello World\0"
#define MAX 20

int testEncryptDecrypt() {
  HOSTKEY hostkey;
  PublicKey pkey;
  RSAEncryptedData target;
  char result[MAX];

  hostkey = makeHostkey();
  getPublicKey(hostkey, &pkey);
  if (SYSERR == encryptHostkey(TESTSTRING,strlen(TESTSTRING)+1,&pkey,
			       &target))
    return SYSERR;
  if (-1 == decryptHostkey(hostkey, &target, result, MAX))
    return SYSERR;
  freeHostkey(hostkey);
  if (strcmp(TESTSTRING,result) == 0) {
    return OK;
  } else {
    printf("%s != %s - testEncryptDecrypt failed!\n",
	   TESTSTRING,result);
    return SYSERR;
  }
}

int testSignVerify() {
  HOSTKEY hostkey;
  Signature sig;
  PublicKey pkey;

  hostkey = makeHostkey();
  getPublicKey(hostkey, &pkey);
  if (SYSERR == sign(hostkey, strlen(TESTSTRING), TESTSTRING, &sig))
    return SYSERR;
  if (OK == verifySig(TESTSTRING, strlen(TESTSTRING), &sig, &pkey)) {
    return OK;
  } else {
    printf("testSignVerify failed!\n");
    return SYSERR;
  }
}

int testHostkeyEncoding() {
  HOSTKEY hostkey;
  HostKeyEncoded * encoding;
  PublicKey pkey;
  RSAEncryptedData target;
  char result[MAX];

  hostkey = makeHostkey();
  getPublicKey(hostkey, &pkey);
  if (SYSERR == encryptHostkey(TESTSTRING,strlen(TESTSTRING)+1,&pkey,
			  &target))
    return SYSERR;
  encoding = encodeHostkey(hostkey);
  freeHostkey(hostkey);
  hostkey = decodeHostkey(encoding);
  free(encoding);
  if (-1 == decryptHostkey(hostkey, &target, result, MAX))
    return SYSERR;
  freeHostkey(hostkey);
  if (strcmp(TESTSTRING,result) == 0) {
    return OK;
  } else {
    printf("%s != %s - testHostkeyEncoding failed!\n",
	   result, TESTSTRING);
    return SYSERR;
  }
}

int main(int argc, char * argv[]) {
  int failureCount = 0;

  if (OK != testEncryptDecrypt())
    failureCount++;
  if (OK != testSignVerify())
    failureCount++;
  if (OK != testHostkeyEncoding()) 
    failureCount++;

  if (failureCount == 0)
    return 0;
  else {
    printf("\n\n%d TESTS FAILED!\n\n",failureCount);
    return -1;
  }
} // end of main
