/** 
 * The following file tests the status calls.
 * @file test/statuscallstest.c
 **/

#include "config.h"
#include "util/statuscalls.h"
#include <stdio.h>
#include "configuration.h"
#include <unistd.h>

int main(){
  char filename[25]=DEFAULT_CONFIG_FILE; 
  int i;
  readConfig((char*)&filename);
  
  if (initStatusCalls(getNetInterfaces(),1) == -1)
    return -1; /* failed! */

  for (i=0;i<3;i++) {
    if (cpuUsage() == -1) {
      printf("cpuUsage == -1\n");
      return -1;
    }
    if (networkUsage() == -1) {
      printf("networkUsage == -1\n");    
      return -1;
    }
    sleep(1);
  }
  /* make sure we don't leak open files... */
  for (i=0;i<10000;i++) {
    if (cpuUsage() == -1)
      return -1;
    if (networkUsage() == -1)
      return -1;
  }
  return 0;
}
