/**
 * Storage - management of the node's main identity.
 * This is the testcase!
 * @author Christian Grothoff
 * @file test/storagetest.c
 **/

#include "config.h"
#include <stdio.h>
#include <string.h>
#include "util/storage.h"

#define TESTSTRING "Hello World\0"

int testReadWrite() {
  HashCode160 ha;
  HexName filename;
  char tmp[100];

  hash(TESTSTRING, 
       strlen(TESTSTRING),
       &ha);
  hash2hex(&ha, &filename);
  writeFile((char*)&filename, TESTSTRING, strlen(TESTSTRING), "644");
  tmp[readFile((char*)&filename, 100, tmp)] = '\0';
  if (memcmp(tmp,TESTSTRING,strlen(TESTSTRING)+1) == 0) 
    return 0;
  else {    
    fprintf(stderr,
	    "Error in testReadWrite: *%s* != *%s* for file %s\n",
	    tmp,TESTSTRING,(char*)&filename);
    return 1;
  }
}

int main(int argc, char * argv[]) {
  int failureCount = 0;

  failureCount += testReadWrite(); 

  if (failureCount == 0)
    return 0;
  else {
    fprintf(stderr,
            "\n\n%d TESTS FAILED!\n\n",failureCount);
    return -1;
  }
} // end of main
