/*
     This file is part of GNUnet.
     (C) 2001, 2002 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * Computation of a CRC32 checksum.
 * @file util/checksum.c
 * @author Christian Grothoff
 **/ 

#include "config.h"
#include "util/checksum.h"
#include <stdlib.h>


/**
 * Compute the CRC32 checksum for the first len
 * bytes of the buffer.
 * @param buf the data over which we're taking the CRC
 * @param len the length of the buffer
 * @return the resulting CRC32 checksum
 **/
int crc32N(void * buf, int len) {
  uLong crc;
  crc = crc32(0L, Z_NULL, 0);
  crc = crc32(crc,(Bytef *)buf,len);
  return crc;
}

/**
 * This method does not really belong here, but
 * where else to put it...
 * @return a random value in the interval [0,i[. 
 **/
int randomi(int i) {
  return (int) (((float)i)*rand()/(RAND_MAX+1.0));
}


/* end of checksum.c */
