/*
     This file is part of GNUnet.
     (C) 2001, 2002 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * ContentDatabase (dispatch implementation, currently bound to GDBM). 
 * @author Christian Grothoff
 * @file util/contentdatabase.c
 **/

#include "config.h"
#include "util/contentdatabase.h"
#include "util/contentdatabase_gdbm.h"
#include "util/xmalloc.h"
#include "util/semaphore.h"

#include <unistd.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <pwd.h>
#include <grp.h>
#include <dirent.h>
#include <errno.h>


void initContentDatabase(char * dir) {  
  initContentDatabase_GDBM(dir);
}

/**
 * Clean shutdown of the storage module (not used at the moment)
 **/
void doneContentDatabase() {
  doneContentDatabase_GDBM();
}

/**
 * Call a method for each entry in the database and
 * call the callback method on it. 
 * @return the number of items stored in the content database
 **/
int forEachEntryInDatabase(void (*callback)(HashCode160*)) {
  return forEachEntryInDatabase_GDBM(callback);
}

/**
 * Read the contents of a bucket to a buffer. 
 * @param name the hashcode representing the filename, not freed!
 * @param len the maximum number of bytes to read
 * @param result the buffer to write the result to
 * @return the number of bytes read on success, -1 on failure
 **/ 
int readContent(HashCode160 * name,
		int  len,
		void * result) {
  return readContent_GDBM(name,len,result);
}

/**
 * Write content to a file. Check for reduncancy and eventually
 * append.
 * @param name the hashcode representing the name of the file (without 
 *        directory)
 * @param block the CONTENT_SIZE bytes long block (no header!)
 **/
void writeContent(HashCode160 * name, 
		  CONTENT_Block * block) {
  writeContent_GDBM(name, block);
}

/**
 * Free space in the database by removing one file
 * @param name the hashcode representing the name of the file (without 
 *        directory)
 **/
void unlinkFromDB(HashCode160 * name) {
  unlinkFromDB_GDBM(name);
}


/* end of contentdatabase.c */
