/*
     This file is part of GNUnet.
     (C) 2001, 2002 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * This module generates sequence numbers for the local node.
 * @file util/sequencer.c
 * @author Christian Grothoff
 **/

#include "config.h"
#include "util/sequencer.h"

/**
 * Internal: the lasts sequence number
 **/
unsigned int sequenceNumber;

/**
 * This method is called whenever a new (part of)
 * a packet is send. 
 * @returns the sequence number of the packet
 **/
unsigned int bumpCounter() {
  return sequenceNumber++;
}

/**
 * @return the current sequence number.
 **/
unsigned int getSequenceNumber() {
  return sequenceNumber;
}

/* end of sequencer.c */
