# 
# This file is licensed under the GPL.  Please see the file "LICENSE" in
# the root directory of this project for terms and conditions.
# (c) 2001 by Trammell Hudson <hudson@swcp.com>
#
package Attitude;
use strict;

=head NAME - Hover::Attitude

Hover::Attitude tracks the roll/pitch/yaw of the gyros
and stores the values into an easily fetched object.
It also draws a wacky AI / DG like object

=cut

sub new
{
	my $class	= shift;
	bless {
	}, $class;
}

sub draw
{
	my $attitude	= shift;
	my $mw		= shift;
	my $width	= shift;
	my $height	= shift || $width;

	my $canvas	= $mw->Canvas(
		-width		=> $width,
		-height		=> $height,
		-background	=> 'lightgreen',
	);

	$attitude->{canvas}	= $canvas;
	$attitude->{width}	= $width;
	$attitude->{height}	= $height;
	return $canvas;
}

# $Id: Attitude.pm,v 1.4 2001/11/10 00:44:03 tramm Exp $

"0, but true";
__END__
