#!/usr/bin/perl -w
package Control;
use strict;
use Control::Curve;
use Servo;
use Joystick;

my $js;
my %controls;

sub joystick
{
	my $class	= shift;
	$js		= shift;
}


sub new
{
	my $class	= shift;
	my %a		= (
		-name		=> 'New control',
		-servo		=> 0,
		-default	=> 0,
		-points		=> [
			# Linear by default, with some control points
			-128		=> -128,
			 -96		=>  -96,
			 -64		=>  -64,
			 -32		=>  -32,
			   0		=>   0,
			  32		=>   32,
			  64		=>   64,
			  96		=>   96,
			 127		=>  127,
		],
		@_,
	);

	my $current = $a{-default};;

	my $curve	= Control::Curve->new(
		$a{-name},
		@{ $a{-points} },
	);

	my $servo	= Servo->new(
		$a{-servo},
	);

	my $y		= $curve->current( $current );
	$servo->set( $y ) if $servo;

	my $control	= bless {
		name		=> $a{-name},
		curve		=> $curve,
		servo		=> $servo,
	}, $class;

	$js->watch_axis( $a{-axis}, sub {
		my $js		= shift;
		my $value	= shift;
		my $y		= $curve->current( $value / 256 );
		$servo->set( $y );
	} ) if exists $a{-axis} and $js;

	$js->watch_button( $a{-button_up}, sub {
		my $js		= shift;
		my $value	= shift
			or return;		# Ignore button up events
		$current += $a{-step};
		$current = -128 if $current < -128;
		$current =  127 if $current >  127;

		my $y		= $curve->current( $current );
		$servo->set( $y );
	} ) if exists $a{-button_up} and $js;

	$js->watch_button( $a{-button_down}, sub {
		my $js		= shift;
		my $value	= shift
			or return;		# Ignore button up events
		$current -= $a{-step};
		$current = -128 if $current < -128;
		$current =  127 if $current >  127;

		my $y		= $curve->current( $current );
		$servo->set( $y );
	} ) if exists $a{-button_down} and $js;

	return $controls{$a{-name}} = $control;
}

sub draw
{
	my $control	= shift;
	$control->{curve}->draw( @_ );
}

sub by_name
{
	my $class	= shift;
	my $name	= shift;
	return $controls{$name};
}

"0, but true";
__END__
