# 
# This file is licensed under the GPL.  Please see the file "LICENSE" in
# the root directory of this project for terms and conditions.
# (c) 2001 by Trammell Hudson <hudson@swcp.com>
#
package Controls;
use strict;

=head NAME - Controls

Draws and maps a control-stick widget.

$Id: Controls.pm,v 1.3 2001/10/05 16:21:18 tramm Exp $

=cut


sub new
{
	my $class		= shift;
	my $mw			= shift;

	my $dot_size		= 5;

	my $controls		= bless {
		width		=> 255,
		height		=> 255,
		x_trim		=> 0,
		y_trim		=> 0,
		x		=> 0,
		y		=> 0,
	}, $class;


	my $frame		= $mw->Frame(
		-border		=> 2,
		-relief		=> 'sunken',
	)->pack(
		-expand		=> 0,
		-fill		=> 'both',
		-side		=> 'top',
	);

	my $top_frame		= $frame->Frame(
	)->pack(
		-expand		=> 1,
		-fill		=> 'both',
		-side		=> 'top',
	);

	$controls->{canvas}	= $top_frame->Canvas(
		-width		=> $controls->{width},
		-height		=> $controls->{height},
		-background	=> 'gray60',
	)->pack(
		-side		=> 'left',
		-expand		=> 1,
		-fill		=> 'both',
	);

	$top_frame->Scale(
		-orient		=> 'vertical',
		-label		=> '',
		-showvalue	=> 0,
		-from		=> -128,
		-to		=>  128,
		-variable	=> \$controls->{y_trim},
	)->pack(
		-side		=> 'right',
		-expand		=> 1,
		-fill		=> 'y',
	);

	$frame->Scale(
		-orient		=> 'horizontal',
		-label		=> '',
		-showvalue	=> 0,
		-from		=> -128,
		-to		=>  128,
		-variable	=> \$controls->{x_trim},
	)->pack(
		-side		=> 'top',
		-expand		=> 1,
		-fill		=> 'x',
	);


	# Draw the "dot" representing the stick position
	$controls->{dot}	= $controls->{canvas}->createArc(
		128 + $controls->{x}, 128 + $controls->{y},
		128 + $controls->{x}+$dot_size, 128 + $controls->{y}+$dot_size,
		-fill		=> 'white',
		-outline	=> 'black',
		-extent		=> 359,
		-start		=> 0,
		-style		=> 'chord',
	);
	
	# Allow it to be dragged

	# And give them an "object"
	return $controls;
}

sub trim
{
	my $control		= shift;
	my $axis		= shift;
	my $trim		= shift;

	$control->{ "${axis}_trim" } = $trim;
}

sub set
{
	my $control		= shift;
	my $axis		= shift;
	my $value		= shift;

	my $x			= $control->{x};
	my $y			= $control->{y};

	$control->{$axis} = $value;

	my $dx			= int( $control->{x} - $x );
	my $dy			= int( $control->{y} - $y );

	$control->{canvas}->move( $control->{dot}, $dx, $dy );
}

"0, but true";
__END__
