#!/usr/bin/perl -w
# 
# This file is licensed under the GPL.  Please see the file "LICENSE" in
# the root directory of this project for terms and conditions.
# (c) 2001 by Trammell Hudson <hudson@swcp.com>
#
# $Id: AI.pm,v 1.3 2001/10/31 19:08:10 tramm Exp $

=head NAME - Hover::EFIS::AI

The Attitude Indicator or "Aritifical Horizon" is the primary flight
instrument for maintaining level flight.

=cut

package EFIS::AI;
use strict;
use base 'Tk::Frame';

Tk::Widget->Construct( 'Attitude' );


sub Populate
{
	my $mw		= shift;
	my $args	= shift;

	my $w		= delete $args->{-width}		|| 128;
	my $h		= delete $args->{-height}		|| 128;

	my $c		= $mw->{canvas} = $mw->Canvas(
		-width		=> $w,
		-height		=> $h + 20,
	)->pack(
		-side		=> 'top',
	);

	$mw->{sky}	= $c->createArc(
		0, 0, $w, $h,
		-start		=> 90,
		-extent		=> 180,
		-fill		=> 'blue',
		-outline	=> 'white',
		-style		=> 'chord',
	);

	$mw->{ground}	= $c->createArc(
		0, 0, $w, $h,
		-start		=> 90,
		-extent		=> -180,
		-fill		=> 'brown',
		-outline	=> 'white',
		-style		=> 'chord',
	);

	$mw->{level}	= $c->createArc(
		0, 0, $w, $h,
		-start		=> 90,
		-extent		=> 180,
		-outline	=> 'white',
		-style		=> 'chord',
	);

		# Attitude attributes
	$mw->{roll}	= 0;
	$mw->{pitch}	= 0;
	$mw->{heading}	= 0;

	$mw->refresh;

	return $mw;
}


sub roll	{ $_[0]->{roll} }
sub pitch	{ $_[0]->{pitch} }
sub heading	{ $_[0]->{heading} }

sub set_pitch
{
	my $ai			= shift;
	my $new_angle		= shift;

	$ai->{pitch}		= $new_angle;

	$ai->refresh;
}

sub set_roll
{
	my $ai			= shift;
	my $new_angle		= shift;

	$ai->{roll}		= $new_angle;
	$ai->refresh;
}

sub set_heading
{
	my $ai			= shift;
	my $new_angle		= shift;
	$ai->{heading}		= $new_angle;
	$ai->refresh;
}

sub refresh
{
	my $efis		= shift;

	$efis->{canvas}->itemconfigure(
		$efis->{sky},
		-start		=> $efis->roll - $efis->pitch,
		-extent		=> + ( 180 + 2 * $efis->pitch ),
	);

	$efis->{canvas}->itemconfigure(
		$efis->{level},
		-start		=> $efis->roll,
	);

	$efis->{canvas}->itemconfigure(
		$efis->{ground},
		-start		=> $efis->roll - $efis->pitch,
		-extent		=> - ( 180 - 2 * $efis->pitch ),
	);

}


"0, but true";
__END__
