# 
# This file is licensed under the GPL.  Please see the file "LICENSE" in
# the root directory of this project for terms and conditions.
# (c) 2001 by Trammell Hudson <hudson@swcp.com>
#
package Servo;
use strict;
use FileHandle;


my $version = q$Id: Servo.pm,v 1.7 2001/10/31 19:08:58 tramm Exp $;

my $global_device;

=head NAME - Servo

Usage:

	my $servo = Servo->new(
		-id		=> 0,
		-device		=> "/dev/serial",
	);

=cut

sub new
{
	my $class		= shift;
	my $id			= shift || 0;
	my $file		= shift || "/dev/ttyS0";

	my $device		= $global_device ||= new FileHandle "$file", O_RDWR
		or warn "Servo: Can not open '$file': $!\n"
		and return;

	$device->autoflush(1);

	my $servo		= bless {
		current		=> 0,
		id		=> $id,
		device		=> $device,
	}, $class;

	$servo->sync;
	return $servo;
}

sub device		{ $_[0]->{device} }
sub id			{ $_[0]->{id} }
sub current		{ $_[0]->{current} }

sub sync
{
	my $servo		= shift;
	my $device		= $servo->device;
	my $flag		= 0xff;

	my $buf =
		chr( $flag ) .
		chr( $servo->id ) .
		chr( 128 + int $servo->current );

=for nobody
	print "Setting servo ", $servo->id, " to ", $servo->current, "\n";
	printf "writing to file: %02x %02x %02x\n",
		map { ord $_ } split //, $buf;
=cut

	syswrite $device, $buf, 3, 0;
}



=head METHODS

$servo->left();		# Move left one units.  Towards zero.
$servo->left( 10 );	# Move left ten units.

$servo->right();	# Move right one unit.  Away from zero.
$servo->right( 10 );	# Move right ten units.

$servo->set( 32 );	# Set the servo to 32 units.

=cut

sub left		{ $_[0]->set( $_[0]->current - ( $_[1] || 1 ) ) }
sub right		{ $_[0]->set( $_[0]->current + ( $_[1] || 1 ) ) }

sub set
{
	my $servo		= shift;
	my $value		= shift;
	my $old_value		= $servo->{current};

	$value = int $value;
	$value = -128		if $value < -128;
	$value = 127		if $value > 127;

	$servo->{current} = $value;
	$servo->sync if $value != $old_value;
}


"0, but true";
__END__
