/*
 * $Id: test-joystick.c,v 1.1.1.1 2001/09/26 00:47:51 tramm Exp $
 *
 * Tests the joystick for readability.  Looks like it works so far.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <linux/joystick.h>

int main( int argc, char *argv[] )
{
	struct js_event e;
	char value;

	int fd;

	fd = open( "/dev/js0", O_RDONLY );
	if( fd < 0 ) {
		perror( "/dev/js0" );
		return -1;
	}

	/* Find out the number of axes */
	if( ioctl( fd, JSIOCGAXES, &value ) == 0 )
		printf( "%x: Joystick has %d axes\n", JSIOCGAXES, (int) value );

	if( ioctl( fd, JSIOCGBUTTONS, &value ) == 0 )
		printf( "%x: Joystick has %d buttons\n", JSIOCGBUTTONS, (int) value );

	printf( "sizeof(js_event) = %d\n", sizeof(struct js_event) );

	return;
	while( read( fd, &e, sizeof( e ) ) > 0 )
	{
		printf( "%08x: %s: ",
			e.time,
			e.type & JS_EVENT_INIT ? "real" : "init"
		);

		if( e.type & JS_EVENT_AXIS ) {
			printf( "axis %d -> %04x\n",
				e.number,
				e.value
			);
			continue;
		}

		if( e.type & JS_EVENT_BUTTON ) {
			printf( "button %d %s\n",
				e.number,
				e.value ? "press" : "release"
			);
			continue;
		}

		printf( "Unknown type %02x\n", e.type );
	}

	return 0;
}
