/**
 *  $Id: adc.c,v 1.8 2001/11/04 05:16:34 tramm Exp $
 *
 * Analog -> Digital conversion routines for the AVR Mega series
 * boards.  We only sample the inputs marked in the interesting
 * flag.
 */

#include <io.h>
#include <sig-avr.h>
#include "adc.h"

static uint8_t		mask;
static uint8_t		current_input_pin = 1;
static uint8_t		current_input = 0;
volatile uint16_t	volts[ 8 ];


/**
 *  Rotate through the interesting bit mask to find the
 * next one of interest.  We check for a zero mask to avoid
 * an endless loop.
 */
static inline void
find_next( void )
{
	if( mask == 0 )
		return;

	do {
		current_input = ( current_input + 1 ) & 7;
		current_input_pin <<= 1;
		if( current_input_pin == 0 )
			current_input_pin = 1;
	} while( !( mask & current_input_pin ) );
	
	outp( current_input, ADMUX );
	sbi( ADCSR, ADSC );
}


/* SIGNAL( SIG_ADC ) */
void
process_adc( void )
{
	uint16_t new = __inw( ADCL );
	uint16_t avg = volts[ current_input ];

	volts[ current_input ] = (avg * 3 + new) / 4;

	find_next();
}


void
adc_init(
	uint8_t		interesting
)
{
	mask = interesting;

	/**
	 *  Enable to A->D converter with a moderate scaling
	 * factor and turn on the interrupts.  The interrupt
	 * routine will cycle through the two gyros and
	 * re-enable the pin each time.
	 */
	outp( 0x07, ADCSR );
/*
	sbi( ADCSR, ACIE );
*/
	sbi( ADCSR, ADEN );

	find_next();
}

