#ifndef _ADC_H_
#define _ADC_H_

/**
 *  $Id: adc.h,v 1.4 2001/11/04 05:16:34 tramm Exp $
 *
 * Analog -> Digital conversion routines for the AVR Mega103
 * series boards.  Only the bits that are high in the "interesting_mask"
 * will be sampled.
 *
 * The actual sample can be found in volts[], and the volts_valid[]
 * value will be set to 1 when a sample is recorded.
 */
#include <io.h>

extern void
adc_init(
	uint8_t		interesting_mask
);

static inline uint8_t
ready_adc( void )
{
	return bit_is_set( ADCSR, ADIF );
}

extern void
process_adc( void );

extern volatile uint16_t	volts[8];

#endif
