/**
 *  $Id: ahrs.c,v 1.6 2001/11/04 03:16:33 tramm Exp $
 *
 * AHRS code.  It integrates the instaneous gyro values to produce
 * a rough idea of the attitude of the aircraft.
 */
#include "ahrs.h"
#include "timer.h"
#include "adc.h"

static int16_t pos[3];
static int16_t mid[3];
static int16_t vel[3];

void
attitude(
	int *			pitch,
	int *			roll,
	int *			yaw
)
{
	*pitch	= pos[0];
	*roll	= pos[1];
	*yaw	= pos[2];
}


/**
 *  The AHRS task attempts to do rate integration on the gyros.
 */
void
rate_integration( void )
{
	/* Compute the pitch */
	vel[0] = ((int16_t)(volts[1] - mid[0])) / 4;
	pos[0] += vel[0];

	/* Compute the roll */
	vel[1] = ((int16_t)(volts[3] - mid[1])) / 4;
	pos[1] += vel[1];

	/* We're not sampling yaw right now */
}


/**
 *  Due to gyro drift and precession errors we have to be able
 * to reset to level at somepoint.
 */
void
reset_level( void )
{
	/* Reset to level */
	vel[0] = vel[1] = vel[2] = 0;
	pos[0] = pos[1] = pos[2] = 0;

	/* Midpoints are the currently sampled values */
	mid[0] = volts[1];
	mid[1] = volts[3];
}

void
ahrs_init( void )
{
	/* Nothing to do? */
}
