#ifndef _AHRS_H_
#define _AHRS_H_

/**
 *  $Id: ahrs.h,v 1.5 2001/11/03 17:01:19 tramm Exp $
 *
 * AHRS code.  It integrates the instaneous gyro values to produce
 * a rough idea of the attitude of the aircraft.
 */
/* User API */
extern void
attitude(
	int *			pitch,
	int *			roll,
	int *			yaw
);


/**
 *  This should be called very 60 Hz or so
 */
extern void
rate_integration( void );

/**
 *  Call when the aircraft is in a "known level" situation.
 */
extern void
reset_level( void );

#endif
