#ifndef _AVR_H_
#define _AVR_H_

/**
 *  $Id: avr.h,v 1.3 2001/11/03 17:01:19 tramm Exp $
 *
 * Top level include for the libavr.a library.
 */
#include "timer.h"
#include "servo.h"
#include "button.h"
#include "uart.h"
#include "adc.h"
#include "ahrs.h"

static inline void
avr_init( void )
{
	servo_init();
	time_init();
	uart_init();
	button_init();
	adc_init( 0xFF );

	/* Turn on interrupts */
	sbi( SREG, 7 );
}


#endif
