#include <io.h>
#include "button.h"

#define LED_PORT	PORTB
#define LED_PORT_DIR	DDRB
#define MAX_LEDS	8

#define BUTTON_PORT	PIND
#define BUTTON_PORT_DIR	DDRD
#define BUTTON_PORT_CFG	PORTD
#define MAX_BUTTONS	8


/**
 *  Initialize the ports
 */
void
button_init( void )
{
	outp( 0xFF, LED_PORT_DIR );
	outp( 0x00, BUTTON_PORT_DIR );
	outp( 0x00, BUTTON_PORT_CFG );

	led_set_mask( 0x00 );
}

/**
 *  Button state
 */
uint8_t
button_get(
	uint8_t			button
)
{
	uint8_t	cur_mask = ~inp( BUTTON_PORT );

	if( MAX_BUTTONS <= button )
		return -1;

	return (cur_mask & (1 << button)) ? 1 : 0;
}


/**
 *  LED stuff
 */
static uint8_t led_mask;

void
led_set(
	uint8_t		led,
	uint8_t		on
)
{
	if( MAX_LEDS <= led )
		return;

	if( on )
		led_mask |= (1<<led);
	else
		led_mask &= ~(1<<led);

	outp( ~led_mask, LED_PORT );
}


void
led_set_mask(
	uint8_t		mask
)
{
	led_mask = mask;
	outp( ~led_mask, LED_PORT );
}
