#ifndef _BUTTON_H_
#define _BUTTON_H_
/**
 *  $Id: button.h,v 1.7 2001/10/24 03:35:27 tramm Exp $
 *
 * Access to the buttons and LED's on the STK300 board.
 */
#include <inttypes.h>

/**
 *  Query a button (and reset its state in the mask)
 */
extern uint8_t
button_get(
	uint8_t		button
);

/**
 *  Reset the state of the button mask
 */
extern void
button_clear( void );


/**
 *  Turn on/off one LED on the board.
 */
extern void
led_set(
	uint8_t		led,
	uint8_t		on
);

/**
 *  Set the LED's to the specified bit pattern
 */
extern void
led_set_mask(
	uint8_t		mask
);



/* Tasks */
extern void button_init( void );

#endif
