/**
 *  $Id: hover.c,v 1.22 2001/10/29 00:47:26 tramm Exp $
 *
 * The main hovering program.
 * Except that it doesn't hover yet, but it does demonstrate all of the
 * features in the code base.
 */

#include "avr.h"


static void
strobe( void )
{
	uint8_t i;
	uint8_t delay	= 50;

	for( i = 0 ; i<3 ; i++ )
	{
		led_set_mask( 0x00 );	msleep( delay );
		led_set_mask( 0xFF );	msleep( delay );
	}

	for( i = 0 ; i < 8 ; i++ )
	{
		led_set( 7 - i, 0 );
		msleep( delay );
	}

	led_set_mask( 0 );
}

static void
status_out( void )
{
	puthexl( time() );
	putchar( ':' );
	putchar( ' ' );

	puthex( in_servos[0] ); putchar( ' ' );
/*
	puthex( in_servos[1] ); putchar( ' ' );
	puthex( in_servos[2] ); putchar( ' ' );
	puthex( in_servos[3] ); putchar( ' ' );
	puthex( in_servos[4] ); putchar( ' ' );
	puthex( in_servos[5] ); putchar( ' ' );
	puthex( in_servos[6] ); putchar( ' ' );
	puthex( in_servos[7] ); putchar( ' ' );
*/

	putnl();
}


void
command( void )
{
	static uint8_t	sync		= 0;
	static uint8_t	servo		= 0xFF;
	uint8_t c;

	while( getchar( &c ) == 0 )
	{
		if( c == 0xFF )
		{
			/* Status byte */
			sync = 1;
			continue;
		}

		if( !sync )
		{
			puts( "?\n\r" );
			continue;
		}

		if( servo == 0xFF )
		{
			/* Servo number */
			servo = c;
			continue;
		}

		/* Must be a Servo position */
#ifdef DEBUG
		puts( "servo " );
		puthexs( servo );
		putchar( ' ' );
		puthexs( c );
		putnl();
#endif

		servo_set( servo, c - 128 );
		sync = 0;
		servo = 0xFF;
	}
}

void
user_task( void )
{
}


int main( void )
{
	/* Turn on the LED's as we come online */
	mainloop_init();

	puts( "$Id: hover.c,v 1.22 2001/10/29 00:47:26 tramm Exp $" );
	putnl();

	strobe();

	add_periodic( status_out );

	mainloop();

	/* Unreached */
	return 0;
}
